/*
 * Decompiled with CFR 0.152.
 */
package noppes.npcs.api.wrapper;

import java.util.Objects;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.item.ItemStack;
import noppes.npcs.api.NpcAPI;
import noppes.npcs.api.constants.EntityType;
import noppes.npcs.api.entity.IEntityItem;
import noppes.npcs.api.item.IItemStack;
import noppes.npcs.api.wrapper.EntityWrapper;
import noppes.npcs.reflection.entity.item.EntityItemReflection;

public class EntityItemWrapper<T extends EntityItem>
extends EntityWrapper<T>
implements IEntityItem {
    public EntityItemWrapper(T entity) {
        super(entity);
    }

    @Override
    public long getAge() {
        return EntityItemReflection.getAge((EntityItem)this.entity);
    }

    @Override
    public IItemStack getItem() {
        return Objects.requireNonNull(NpcAPI.Instance()).getIItemStack(((EntityItem)this.entity).func_92059_d());
    }

    @Override
    public int getLifeSpawn() {
        return ((EntityItem)this.entity).lifespan;
    }

    @Override
    public String getOwner() {
        return ((EntityItem)this.entity).func_145798_i();
    }

    @Override
    public int getPickupDelay() {
        return ((EntityItem)this.entity).field_145804_b;
    }

    @Override
    public int getType() {
        return EntityType.ITEM.get();
    }

    @Override
    public void setAge(long age) {
        EntityItemReflection.setAge((EntityItem)this.entity, (int)Math.max(Math.min(age, Integer.MAX_VALUE), 0L));
    }

    @Override
    public void setItem(IItemStack item) {
        ItemStack stack = item == null ? ItemStack.field_190927_a : item.getMCItemStack();
        ((EntityItem)this.entity).func_92058_a(stack);
    }

    @Override
    public void setLifeSpawn(int age) {
        ((EntityItem)this.entity).lifespan = age;
    }

    @Override
    public void setOwner(String name) {
        ((EntityItem)this.entity).func_145797_a(name);
    }

    @Override
    public void setPickupDelay(int delay) {
        ((EntityItem)this.entity).func_174867_a(delay);
    }

    @Override
    public boolean typeOf(int type) {
        return type == EntityType.ITEM.get() || super.typeOf(type);
    }
}

